//Dustin Soodak


//
//behavior 033:
//Look at amplitude and direction of acceleration using SimpleNavigation()
//compare still to moving forward and record acceleration data to be spit out later
#include "MiscHardware.h"
#include "Navigation.h"
#include <math.h>
void setup(){
  HardwareBegin();
  SwitchButtonToPixels();
  PlayChirp(1000, 50);SetPixelRGB(5,0,0,50);SetPixelRGB(6,0,0,50);RefreshPixels();
  delay(100);
  PlayChirp(1000, 0);SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();  
  
}
int accelx,accely,accelz,dir;
int i;
int accelraw[3];
int accel[3];
int32_t rawaccelsquared,accelsquared;
//
#define DAT_SIZE (400)
int dat[DAT_SIZE];
int datpos=0;
char motorson=0;
//
char ch;
String NumString="";
int motoroffset=0;
void loop(){
  SwitchPixelsToButton();    
  while(!ButtonPressed()){
    if(Serial.available() > 0){
      ch = Serial.read();    
      if (isDigit(ch) || ch=='-'){
        NumString += (char)ch;  
      }
      if(ch=='\n'){      
        motoroffset=NumString.toInt();//-25 works well for robot 1
        NumString="";
        Serial.println(motoroffset,DEC);
      }  
    }//end if(Serial.available() > 0)
  }
  delay(1000);
  NavigationBegin();  
  RestartTimer();
  SetPixelRGB(5,50,0,0);SetPixelRGB(6,50,0,0);RefreshPixels();
  datpos=0;
  while(1){
    //SimpleNavigation();
    if(AccelBufferSize()>0)
      AccelGetAxes(AccelAcceleration);  
    //
    //accelx=AccelAcceleration[0];
    //accely=AccelAcceleration[1];
    //accelz=AccelAcceleration[2];
    accelx=GetAccelerationX();
    accely=GetAccelerationY();
    accelz=GetAccelerationZ();
    rawaccelsquared=0;
    for(i=0;i<3;i++){
      //accelraw[i]=AccelAcceleration[i]+AccelZeroes[i];//if using SimpleNavigation()
      accelraw[i]=AccelAcceleration[i];//if using AccelGetAxes(AccelAcceleration)
      rawaccelsquared+=((int32_t)accelraw[i])*((int32_t)accelraw[i]);
    }
    accelsquared=0;
    for(i=0;i<3;i++){
      accel[i]=accelraw[i]*(-(float)(2*9800)/32768);
      accelsquared+=((int32_t)accel[i])*((int32_t)accel[i]);
    }  
    dir=90-atan2(accely,accelx)*180/3.14159;
    //
    if(datpos<DAT_SIZE){
      dat[datpos]=accelraw[1];
      datpos++;
    }
    if(motorson==0 && datpos==(DAT_SIZE>>1)){
      motorson=1;
      SwitchButtonToPixels();
      SetPixelRGB(5,0,50,0);SetPixelRGB(6,0,50,0);RefreshPixels();
      SwitchSerialToMotors();
      Motors(150+motoroffset,150-motoroffset); 
    }
    if(datpos==DAT_SIZE && motorson){
      motorson=0; 
      SwitchButtonToPixels();
      SetPixelRGB(5,0,0,0);SetPixelRGB(6,0,0,0);RefreshPixels();
      SwitchSerialToMotors();
      Motors(0,0);
      
    }
    //
    SwitchPixelsToButton(); 
    if(ButtonPressed()){
      for(i=0;i<datpos;i++){
        Serial.println(dat[i],DEC); 
      }
      //
      break;
    }
    if(GetTime()>200 && datpos==DAT_SIZE){//
      SwitchMotorsToSerial();
      Serial.print(accelx,DEC);
      Serial.print(" ");
      Serial.print(accely,DEC);
      Serial.print(" ");
      Serial.print(accelz,DEC);
      Serial.print(" dir ");
      Serial.println(dir,DEC);
      Serial.print(" x ");
      Serial.print(accel[0],DEC);
      Serial.print(" y ");
      Serial.print(accel[1],DEC);
      Serial.print(" z ");
      Serial.print(accel[2],DEC);
      Serial.println();
      Serial.print(" raw amplitude ");
      Serial.print(sqrt(rawaccelsquared),DEC);
      Serial.print(" amplitude ");    
      Serial.print(sqrt(accelsquared),DEC);
      Serial.println();
      RestartTimer(); 
      //
      
    }
  }//end while(1)
  
}//end loop()


